/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend;

import net.fabricmc.api.ModInitializer;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1959;
import net.minecraft.class_1972;
import net.minecraft.class_2960;
import net.minecraft.class_6880;
import org.betterx.bclib.api.v2.generator.BiomeDecider;
import org.betterx.bclib.api.v2.levelgen.biomes.BiomeAPI;
import org.betterx.betterend.advancements.BECriteria;
import org.betterx.betterend.api.BetterEndPlugin;
import org.betterx.betterend.commands.CommandRegistry;
import org.betterx.betterend.config.Configs;
import org.betterx.betterend.effects.EndPotions;
import org.betterx.betterend.integration.Integrations;
import org.betterx.betterend.integration.trinkets.Elytra;
import org.betterx.betterend.recipe.AlloyingRecipes;
import org.betterx.betterend.recipe.AnvilRecipes;
import org.betterx.betterend.recipe.CraftingRecipes;
import org.betterx.betterend.recipe.FurnaceRecipes;
import org.betterx.betterend.recipe.InfusionRecipes;
import org.betterx.betterend.recipe.SmithingRecipes;
import org.betterx.betterend.registry.EndAdvancements;
import org.betterx.betterend.registry.EndBiomes;
import org.betterx.betterend.registry.EndBlockEntities;
import org.betterx.betterend.registry.EndBlocks;
import org.betterx.betterend.registry.EndEnchantments;
import org.betterx.betterend.registry.EndEntities;
import org.betterx.betterend.registry.EndFeatures;
import org.betterx.betterend.registry.EndItems;
import org.betterx.betterend.registry.EndMenuTypes;
import org.betterx.betterend.registry.EndPoiTypes;
import org.betterx.betterend.registry.EndPortals;
import org.betterx.betterend.registry.EndSounds;
import org.betterx.betterend.registry.EndStructures;
import org.betterx.betterend.registry.EndTags;
import org.betterx.betterend.util.BonemealPlants;
import org.betterx.betterend.util.LootTableUtil;
import org.betterx.betterend.world.generator.EndLandBiomeDecider;
import org.betterx.betterend.world.generator.GeneratorOptions;
import org.betterx.worlds.together.util.Logger;
import org.betterx.worlds.together.world.WorldConfig;

public class BetterEnd
implements ModInitializer {
    public static final String MOD_ID = "betterend";
    public static final Logger LOGGER = new Logger("betterend");
    public static final boolean RUNS_TRINKETS = FabricLoader.getInstance().getModContainer("trinkets").isPresent();

    public void onInitialize() {
        WorldConfig.registerModCache((String)MOD_ID);
        EndPortals.loadPortals();
        EndSounds.register();
        EndMenuTypes.ensureStaticallyLoaded();
        EndBlockEntities.register();
        EndPoiTypes.register();
        EndFeatures.register();
        EndEntities.register();
        EndBiomes.register();
        EndTags.register();
        EndBlocks.ensureStaticallyLoaded();
        EndItems.ensureStaticallyLoaded();
        EndEnchantments.register();
        EndPotions.register();
        CraftingRecipes.register();
        FurnaceRecipes.register();
        AlloyingRecipes.register();
        AnvilRecipes.register();
        SmithingRecipes.register();
        InfusionRecipes.register();
        EndStructures.register();
        BonemealPlants.init();
        GeneratorOptions.init();
        LootTableUtil.init();
        CommandRegistry.register();
        BECriteria.register();
        EndAdvancements.register();
        FabricLoader.getInstance().getEntrypoints(MOD_ID, BetterEndPlugin.class).forEach(BetterEndPlugin::register);
        Integrations.init();
        Configs.saveConfigs();
        if (GeneratorOptions.useNewGenerator()) {
            BiomeDecider.registerHighPriorityDecider((class_2960)BetterEnd.makeID("end_land"), (BiomeDecider)new EndLandBiomeDecider());
        }
        BiomeAPI.registerEndBiomeModification((biomeID, biome) -> {
            if (!biomeID.equals((Object)class_1972.field_9473.method_29177())) {
                EndFeatures.addBiomeFeatures(biomeID, (class_6880<class_1959>)biome);
            }
        });
        BiomeAPI.onFinishingEndBiomeTags((biomeID, biome) -> {
            if (!biomeID.equals((Object)class_1972.field_9473.method_29177())) {
                EndStructures.addBiomeStructures(biomeID, (class_6880<class_1959>)biome);
            }
        });
        if (RUNS_TRINKETS) {
            Elytra.register();
        }
    }

    public static class_2960 makeID(String path) {
        return new class_2960(MOD_ID, path);
    }
}

